//
//  IFAACheckViewController.m
//  IDaaSDoraemonDemo
//
//  Created by 九州云腾 on 2021/7/15.
//

#import "IFAACheckViewController.h"
#import <IDaaSDoraemonSDK/IDaaSDoraemonManager.h>
@interface IFAACheckViewController ()

@property (weak, nonatomic) IBOutlet UITextView *idToken;
@end

@implementation IFAACheckViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.navigationController.navigationBar setBackgroundImage:[[UIImage alloc] init] forBarMetrics:UIBarMetricsDefault];
    [self.navigationController.navigationBar setShadowImage:[[UIImage alloc] init]];
    
    [[IDaaSDoraemonManager sharedInstance]authenticatorServiceWithAuthMethod:@"IFAA" action:DoraemonAuthTypeDeregister userId:self.userId complete:^(NSDictionary *resultDic) {
        
        HKLog(@"IFAA认证器注销成功 %@",resultDic);
    }];
    
}
// simpleIFAAInit
- (IBAction)registerIFAA:(id)sender{
    
    [[IDaaSDoraemonManager sharedInstance]authenticatorServiceWithAuthMethod:@"IFAA" action:DoraemonAuthTypeRegister userId:self.userId complete:^(NSDictionary *resultDic) {
        
        HKLog(@"IFAA认证器-注册结果 %@",resultDic);
    }];
    
}
// simpleIFAAAuth
- (IBAction)authIFAA:(id)sender{
    
    [[IDaaSDoraemonManager sharedInstance]authenticatorServiceWithAuthMethod:@"IFAA" action:DoraemonAuthTypeAuth userId:self.userId complete:^(NSDictionary *resultDic) {
        dispatch_async(dispatch_get_main_queue(), ^{
            HKLog(@"IFAA认证器-认证结果 %@",resultDic);
            NSNumber *code = [resultDic objectForKey:@"code"];
            if (code.intValue == 200) {
                self.idToken.text = [[resultDic objectForKey:@"data"] objectForKey:@"idToken"];
            }
        });
        
    }];
}

@end
