/**
 * @(#) IFAAAuthenticator module  1.0 2016/12/12
 *
 * Copyright (c) 2014, IFAA and/or its affiliates. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * -Redistribution of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *
 * -Redistribution in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *
 * Neither the name of IFAA or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
 * ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. IFAA, INC.
 * AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE
 * AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL IFAA OR ITS LICENSORS BE LIABLE FOR ANY LOST
 * REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL,
 * INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY
 * OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF IFAA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or intended
 * for use in the design, construction, operation or maintenance of any
 * nuclear facility.
 *
 * ***********************************************************************************
 *
 * This file implements the interfaces that library presents to client programs, and
 * is intended for call from Trusted Execution Application.
 */

#import <Foundation/Foundation.h>
#import <IFAAAuthenticator/IFAAAuthRequest.h>
#import <IFAAAuthenticator/IFAAAuthResponse.h>
#import <IFAAAuthenticator/IFAAAuthInfo.h>

/**
 * 如定义该值，则使用group，否则开通数据均存入keychain private空间
 */
extern NSString *IFAA_KEYCHAIN_ACCESS_GROUP;

typedef void (^IFAAAuthCallback)(IFAAAuthResponse*);

@interface IFAAAuthenticator : NSObject
/**
 * 注册
 * 注: callback不保证在main线程，如有ui操作，请自行做线程分配
 */
+ (void)doRegister:(IFAAAuthRequest*)request callback:(IFAAAuthCallback)callback;

/**
 * 校验
 * 注: callback不保证在main线程，如有ui操作，请自行做线程分配
 */
+ (void)doAuthenticate:(IFAAAuthRequest*)request callback:(IFAAAuthCallback)callback;

/**
 * 注销
 * 注: callback不保证在main线程，如有ui操作，请自行做线程分配
 */
+ (void)doDeregister:(IFAAAuthRequest*)request callback:(IFAAAuthCallback)callback;

/**
 * 获取注册时所需本地信息
 */
+ (IFAAAuthInfo*)getRegInfo;

/**
 * 获取校验时所需本地信息
 */
+ (IFAAAuthInfo*)getAuthInfo:(NSString*)ifaaToken;

/**
 * 获取设备标识
 */
+ (NSString*)getDeviceId;

+ (NSString*)getDiagnoseInfo;

/**
 * 获取支持的生物验证类型
 */
+ (IFAABioType) getSupportBioType;
@end

///检测系统是否越狱(应用方自行实现)
#ifdef __cplusplus
extern "C"
#endif
bool checkEnviromentSecurity();
