//
//  EtasConfiguration.h
//  esand_ios_demo
//
//  Created by ReidLee on 2018/2/7.
//  Copyright © 2018年 esandinfo. All rights reserved.
//
#import <Foundation/Foundation.h>

/**
 * ### 此类的用于记录 `EtasManager` 的配置信息, <font color=red>一定要用 `initWithAuthType` 进行初始化</font>
 */
@interface EtasConfiguration:NSObject

// 交易ID , 需要调用者传入
@property  (nonatomic, copy) NSString *trancId;
// 业务数据， 需要调用者传入
@property  (nonatomic, copy) NSString *payload;
// 用户 ID, 需要调用者传入
@property  (nonatomic, copy) NSString *userId;
// 生物认证类型，默认是 `IfaaAuthType.AUTHTYPE_FINGERPRINT` ， 目前也只支持指纹
@property  (nonatomic) int authType;
// fallbackTitle:验证TouchID时在错误一次的后显示出的可选项按钮标题。
@property  (nonatomic, copy) NSString *fallbackTitle;
// reasonTitle:验证理由说明文字，会显示在对话框中部。
@property  (nonatomic, copy) NSString *reasonTitle;
// cancelTitle:取消按钮显示文字。
@property  (nonatomic, copy) NSString *cancleTitle;
// trancType:业务数据，业务场景，每个业务场景的IFAA状态相互独立。
@property  (nonatomic, copy) NSString *trancType;
// 一次指纹注册的token， 次值在注册的时候由服务器生成返回并保存在终端
@property  (nonatomic, copy) NSString *token;
// useLocalAuth:指纹或人脸注册时是否进行本地认证，默认：YES使用。
@property  (nonatomic) BOOL useLocalAuth;
// useSDKPinUI:Pin码注册以及认证时是否使用SDK的UI，默认：NO不使用。
@property  (nonatomic) BOOL useSDKPinUI;
// useSDKGestureUI:手势注册以及认证时是否使用SDK的UI，默认：NO不使用。
@property  (nonatomic) BOOL useSDKGestureUI;
// isSimpleIFAA:是否是simpleIFAA流程，接入方无需关注的属性，默认：NO。
@property  (nonatomic) BOOL isSimpleIFAA;

/**
***初始化方法***
- Params:
 - authType: 认证方式。请参考 `IfaaAuthType` 。
 - trancId: 能够唯一区别本次IFAA操作的交易ID。此交易ID可以唯一定位此次操作。
 - userId: 用户ID或者能够区别用户的唯一表示信息。
 - payload: 需要做签名校验业务相关信息。
 - fallbackTitle: 验证TouchID时在错误一次的后显示出的可选项按钮标题。
 - reasonTitle: 验证理由说明文字，会显示在对话框中部。
 - cancelTitle: 取消按钮显示文字。

- returns: self of `EtasConfiguration`
*/
- (id)initWithAuthType:(int) authType
               trancId:(NSString *)trancId
                userId:(NSString *)userId
               payload:(NSString *)payload
         fallbackTitle:(NSString *)fallbackTitle
           reasonTitle:(NSString *)reasonTitle
           cancelTitle:(NSString *)cancelTitle;

/**
 ***初始化方法***
 - Params:
  - authType: 认证方式。请参考 `IfaaAuthType` 。
  - trancId: 能够唯一区别本次IFAA操作的交易ID。此交易ID可以唯一定位此次操作。
  - userId: 用户ID或者能够区别用户的唯一表示信息。
  - payload: 需要做签名校验业务相关信息。
  - trancType: 本次IFAA操作的交易类型。
  - fallbackTitle: 验证TouchID时在错误一次的后显示出的可选项按钮标题。
  - reasonTitle: 验证理由说明文字，会显示在对话框中部。
  - cancelTitle: 取消按钮显示文字。
 - returns: self of `EtasConfiguration`
 */
- (id)initWithAuthType:(int) authType
               trancId:(NSString *)trancId
                userId:(NSString *)userId
               payload:(NSString *)payload
             trancType:(NSString *)trancType
         fallbackTitle:(NSString *)fallbackTitle
           reasonTitle:(NSString *)reasonTitle
           cancelTitle:(NSString *)cancelTitle;

// 获取注册请求 json 数据
- (NSString *)getRegInitJSON;
// 获取注册响应 json 数据
- (NSString *)getRegRspJSON:(NSString *)ifaaMsg;

// 获取认证请求 json 数据
- (NSString *)getAuthInitJSON;
// 获取认证响应 json 数据
- (NSString *)getAuthRspJSON:(NSString *)ifaaMsg;
// 获取指位更新 json 数据
- (NSString *)getTemplateUpdateJSON:(NSString *)ifaaMsg;

// 获取注销请求 json 数据
- (NSString *)getDeregInitJSON;
// 获取查询注册状态 json 数据
- (NSString *)getCapRequetJSON;
// 获取查询注册状态 json 数据
- (NSString *)getCapRequetJSON:(NSString*) syncRequest;

@end
