//
//  EtasResult.h
//  etasSdk
//
//  Created by ReidLee on 2018/6/15.
//  Copyright © 2018年 esandinfo. All rights reserved.
//
#import <Foundation/Foundation.h>
#import "IfaaCommon.h"
#import "EtasResult.h"

/**
 Etas 执行结果
 */
@interface EtasResult : NSObject

/**
 回调代码块定义

 @param etasResult 执行结果 `EtasResult`
 */
typedef void (^EtasCallback)(EtasResult* etasResult);
- (id) initWithCode:(enum IFAAErrorCodeEnum)code msg:(NSString *) msg;

/**
 执行结果的状态码，可参考 `IFAAErrorCodeEnum`
 */
@property enum IFAAErrorCodeEnum code;

/**
 执行结果数据
 */
@property  (nonatomic, copy) NSString *msg;

@end

