//
//  IfaaCommon.h
//  esand_ios_demo
//
//  Created by ReidLee on 2018/2/23.
//  Copyright © 2018年 esandinfo. All rights reserved.
//

#ifndef IfaaCommon_h
#define IfaaCommon_h

#define IFAA_TRANSPORT_ENCRYPT_KEY @"ifaa.transport.encrypt.key"
#define IFAA_TRANSPORT_SIGNATURE_KEY @"ifaa.transport.signature.key"
#define IFAA_DEVICE_SIGNATURE_KEY @"ifaa.device.signature.key"
#define IFAA_DEVICE_HW_KEY @"ifaa.device.hw.key"
#define IFAA_DEVICE_STORE_KEY @"ifaa.device.store.key"

// IFAA 的处理流程
typedef enum IFAAProcess {
    /**
     * 注册请求流程
     */
    REG_GETREQ,
    /**
     * 注册响应流程
     */
    REG_SENDRESP,
    /**
     * 认证请求流程
     */
    AUTH_GETREQ,
    /**
     * 认证响应流程
     */
    AUTH_SENDRESP,
    /**
     * 更新指位响流程
     */
    MUITLFINGERS_AUTH_SENDRESP,
    /**
     * 注销请求流程
     */
    DEREG_REQ,
    /**
     * 检查服务器注册状态请求流程
     */
    CHECK_REG_STATUS,
} IFAAProcess;


// IFAA 服务器返回的状态码枚举
typedef enum IFAA_RESPONSE_CODES {
    /**
     * 一切正常
     */
    IFAA_ERR_SUCCESS = 0X00,
    /**
     * 系统异常，未知错误
     */
    IFAA_ERR_UNKNOWN = 0X01,
    /**
     * 没有找到请求token对应的信息
     */
    IFAA_ERR_TOKEN_NOT_FOUND = 0X02,
    /**
     * 参数有误
     */
    IFAA_ERR_WRONG_PARAM = 0X03,
    /**
     * token对应的信息不匹配
     */
    IFAA_ERR_NOT_MATCH = 0X04,
    /**
     * IFAA协议体签名错误
     */
    IFAA_ERR_INVALID_SIG = 0X05,
    /**
     * 请求CHALLENGE超时
     */
    IFAA_ERR_TIMEOUT = 0X06,
    /**
     * 没有找到挑战码
     */
    IFAA_ERR_WRONG_CHALLENGE = 0X07,
    /**
     * 指位已变更，指位不匹配
     */
    IFAA_ERR_WRONG_AUTHDATAINDEX = 0X08,
    /**
     * 被风险策略拒绝时
     */
    IFAA_ERR_POLICY = 0X09,
    /**
     * 用户被禁用时
     */
    IFAA_ERR_USER_STATUS = 0X0A,
    /**
     * 应用白名单中未设置应用标识
     */
    IFAA_ERR_APPID_NOT_FOUND = 0X0B,
    /**
     * 设备型号不存在
     */
    IFAA_ERR_DEVICE_MODEL_NOT_FOUND = 0X0C,
    /**
     * 未获取到签名数据
     */
    IFAA_ERR_SIGNATURE_FAIL = 0X0D,
    /**
     * 设备密钥被禁用
     */
    IFAA_ERR_DEVICE_KEY_NOT_FOUND = 0X0F,
    /**
     * 认证器被禁用
     */
    IFAA_ERR_AUTHENTICATOR_DISABLE = 0x10,
    /**
     * 未找到相应的认证器
     */
    IFAA_ERR_AUTHENTICATOR_NOT_FOUND = 0x11,
    /**
     * 受保护的业务数据不匹配
     */
    IFAA_ERR_PROTECT_PAYLOAD_NOT_MATCH = 0x12

} IFAA_RESPONSE_CODES;

typedef enum IfaaBioResult {
    /// 成功
    CLIENT_RESULT_SUCCESS = 100,
    /// 用户点击了'cancel'
    CLIENT_RESULT_USER_CANCEL = 101,
    /// 系统版本低于iOS8
    CLIENT_RESULT_NOT_SUPPORT = 102,
    /// 被其他进程抢占，如来电
    CLIENT_RESULT_SYSTEM_CANCEL  = 103,
    /// passcode未设置
    CLIENT_RESULT_PASSCODE_NOTSET  = 104,
    /// 指纹不匹配
    CLIENT_RESULT_NO_MATCH   = 105,
    /// 用户点击了'Enter Passcode'
    CLIENT_RESULT_FALLBACK    = 106,
    /// 未录入指纹
    CLIENT_RESULT_NOT_ENROLLED    = 107,
    /// 不可用
    CLIENT_RESULT_NOT_AVAILABLE   = 108,
    ///系统指纹异常
    CLIENT_RESULT_TOUCHID_ERROR  = 109,
    //    ///该机器越狱
    //    public static let CLIENT_RESULT_JAILBREAK  = 110
    /// 参数不对
    CLIENT_RESULT_WRONG_PARAM   = 111,
    // 连续多次失败，被锁定(3次)
    CLIENT_RESULT_LOCKOUT  = 113,
    /// 校验错误包含其中
    CLIENT_RESULT_UNKNOWN  = 112,
} IfaaBioResult;

/**
 * IFAA 支持的认证类型枚举
 */
typedef enum IfaaAuthType {
    /// 指纹 (ios 8.0 开始支持)
    AUTHTYPE_FINGERPRINT = 1,
    /// 人脸 (iphone x)
    AUTHTYPE_FACEID = 1 << 2,
    /// PIN码
    IFAA_AUTHTYPE_PIN = 1 << 31,
    /// 手势
    IFAA_AUTHTYPE_GESTURE = 1 << 30
} IfaaAuthType;

/**
 * IFAA 错误回调code枚举
 */
typedef enum IFAAErrorCodeEnum {
    /**
     * 成功
     */
    IFAA_SUCCESS,
    /**
     * 支持除指纹/人脸以外的认证类型，如pin/手势等
     */
    IFAA_STATUS_SUPPORT_OTHERS,
    /**
     * 终端支持IFAA的指纹服务（Touch ID）
     */
    IFAA_STATUS_FINGERPRINT,
    /**
     * 终端支持IFAA的人脸服务（Face ID）
     */
    IFAA_STATUS_FACE_ID,
    /**
     * 终端没有录入指纹/人脸 (此时可以引导用户去录入指纹/人脸再做操作)
     */
    IFAA_STATUS_NOT_ENROLLED,
    /**
     * IFAA 尚未注册 (比如认证/注销/指位更新等操作都需要注册后才可以进行)
     */
    IFAA_STATUS_NOT_REGISTERED,
    /**
     * IFAA 已经注册 (这只是一个状态，并不是错误)
     */
    IFAA_STATUS_REGISTERED,
    /**
     * 尚未设置屏幕锁密码 （IFAA 需要设置屏幕锁后才能进行，否则不安全，此处可引导用户去设置屏幕锁）
     */
    IFAA_STATUS_PASSCODE_NOT_SET,
    /**
     * 本地执行异常 (错误发生在app执行过程中)
     */
    IFAA_CLIENT_ERROR,
    /**
     * IFAA 服务器错误 （此错误发生在服务器）
     */
    IFAA_SERVER_ERROR,
    /**
     * 网络错误
     */
    IFAA_NETWORK_ERROR,
    /**
     * 指位/人脸不匹配，需要更新指位/人脸, 可参考 [指位更新](http://bbs.esandinfo.com/topic/46/ifaa流程拆分-ios-ifaa-指位更新)
     */
    IFAA_WRONG_AUTHDATAINDEX,
    /**
     * - 被风险策略拒绝时， 可参考 [关于bizServer 风险策略拒绝](http://bbs.esandinfo.com/topic/51/关于bizserver-风险策略拒绝)
     */
    IFAA_POLICY_REJECTED,
    /**
     * 用户被禁用时， 可参考 [关于bizServer 用户被禁用](http://bbs.esandinfo.com/topic/52/关于bizserver-用户禁用)
     */
    IFAA_USER_REJECTED,
    /**
     * 应用白名单中未设置应用标识
     */
    IFAA_APPID_NOT_FOUND,
    /**
     * 设备型号不存在
     */
    IFAA_DEVICE_MODEL_NOT_FOUND,
    /**
     * 未获取到签名数据
     */
    IFAA_SIGNATURE_FAIL,
    /**
     * 本地指纹已经注册，但是注册的指纹模组数据已经被删除(Android独有)
     */
    IFAA_STATUS_DELETED,
    /**
     * 此手机不支持多指位(Android独有)
     */
    IFAA_CLIENT_ERROR_MULTI_FP_NOT_SUPPORT,
    /**
     * 用户取消
     */
    IFAA_STATUS_RESULT_CANCELED,
    /**
     * 超时(Android独有)
     */
    IFAA_STATUS_RESULT_TIMEOUT,
    /**
     * 验证失败，系统指纹不匹配
     */
    IFAA_STATUS_RESULT_AUTH_FAIL,
    /**
     * 连续多次校验失败，指纹校验被暂时锁定(暂时Android独有)
     */
    IFAA_STATUS_RESULT_SYSTEM_BLOCK,
    /**
     * 点击了 FALLBACK 按钮
     */
    IFAA_STATUS_RESULT_FALLBACK,
    /**
     * TEE 错误(Android独有)
     */
    IFAA_STATUS_RESULT_TEE_ERROR,
    /**
     * 手机系统问题，请升级系统版本(Android独有)
     */
    IFAA_STATUS_RESULT_SYSTEM_ERROR,
    /**
     * -Android:当前设备未获取相机权限
     * -IOS:当前应用未获取Face ID权限
     */
    IFAA_PERMISSION_DENIED,
    /**
     *认证器被禁用
     */
    IFAA_AUTHENTICATOR_DISABLE,
    /**
     *未找到相应的认证器
     */
    IFAA_AUTHENTICATOR_NOT_FOUND,
    /**
     * 设备密钥被禁用
     */
    IFAA_DEVICE_KEY_NOT_FOUND,
    /**
     * 受保护的业务数据不匹配
     */
    IFAA_PROTECT_PAYLOAD_NOT_MATCH

} IFAAErrorCodeEnum;

#endif /* IfaaCommon_h */
