

#import "PhoneNumberCheckViewController.h"


#import <ATAuthSDK/ATAuthSDK.h>
#import <IDaaSDoraemonSDK/IDaaSDoraemonManager.h>
#import "ProgressHUD.h"
#import "DoraemonModelCreate.h"

@interface PhoneNumberCheckViewController ()

@end

@implementation PhoneNumberCheckViewController

#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"手机号认证Demo";
    [self.navigationController.navigationBar setBackgroundImage:[[UIImage alloc] init] forBarMetrics:UIBarMetricsDefault];
    [self.navigationController.navigationBar setShadowImage:[[UIImage alloc] init]];
    // 检测当前环境是否支持一键登录，支不支持提前知道 (PNSAuthTypeLoginToken 检查一键登录环境 PNSAuthTypeVerifyToken 检查号码认证环境)
    __block BOOL support = YES;
    [[TXCommonHandler sharedInstance] checkEnvAvailableWithAuthType:PNSAuthTypeLoginToken complete:^(NSDictionary * _Nullable resultDic) {
        support = [PNSCodeSuccess isEqualToString:[resultDic objectForKey:@"resultCode"]];
    }];
}

- (IBAction)vertifyPhone:(id)sender {
    UIControlOptions *options = [[UIControlOptions alloc]init];
    options.phoneNumber = @"17600909806";
    [[IDaaSDoraemonManager sharedInstance]SDKAuthenticateWithUserId:@"baowei110" action:DoraemonAuthTypeVerifyToken  options:options complete:^(NSDictionary *resultDic) {
        HKLog(@"token %@",resultDic);
    }];
}
- (IBAction)quickLogin:(id)sender {
    
    __weak typeof(self) weakSelf = self;
    TXCustomModel *model = [weakSelf buildCustomModel:NO];
    model.supportedInterfaceOrientations = YES;
    UIControlOptions *options = [[UIControlOptions alloc]init];
    options.controller = weakSelf;
    options.customModel = model;
    options.timeOut = 3.0;
    [[IDaaSDoraemonManager sharedInstance]SDKAuthenticateWithUserId:@"baowei110" action:DoraemonAuthTypeLoginToken  options:options complete:^(NSDictionary *resultDic) {
        NSString *code = [resultDic objectForKey:@"code"];
        if ([PNSCodeLoginControllerPresentSuccess isEqualToString:code]) {
            HKLog(@"弹起授权页成功");
        } else if ([PNSCodeLoginControllerClickCancel isEqualToString:code]) {
            HKLog(@"点击了授权页的返回");
        } else if ([PNSCodeLoginControllerClickChangeBtn isEqualToString:code]) {
            HKLog(@"点击切换其他登录方式按钮");
        } else if ([PNSCodeLoginControllerClickLoginBtn isEqualToString:code]) {
            if ([[resultDic objectForKey:@"isChecked"] boolValue] == YES) {
                HKLog(@"点击了登录按钮，check box选中，SDK内部接着会去获取登陆Token");
            } else {
                HKLog(@"点击了登录按钮，check box选中，SDK内部不会去获取登陆Token");
            }
        } else if ([PNSCodeLoginControllerClickCheckBoxBtn isEqualToString:code]) {
            HKLog(@"点击check box");
        } else if ([PNSCodeLoginControllerClickProtocol isEqualToString:code]) {
            HKLog(@"点击了协议富文本");
        } else if ([AuthSuccess isEqualToString:code]) {
            //点击登录按钮获取登录Token成功回调
            HKLog(@"token %@",resultDic);
        }
    }];
}
- (TXCustomModel *)buildCustomModel:(BOOL)isAlert {
    if (isAlert) {
        return [DoraemonModelCreate createAlert];
    } else {
        return [DoraemonModelCreate createFullScreen];
    }
}
-(void)ifaaClick{
    HKLog(@"ifaa登录");
 
}
- (void)dealloc {
    HKLog(@"PhoneNumberCheckViewController dealloc()");
}

@end
