//
//  IDaaSDoraemonManagerSDK.h
//  IDaaSDoraemonSDK
//
//  Created by 九州云腾 on 2021/6/18.
//

#import <Foundation/Foundation.h>
#import "UIControlOptions.h"

typedef NS_ENUM (NSInteger, DoraemonAuthType) {
    DoraemonAuthTypeRegister = 1,  //注册
    DoraemonAuthTypeAuth = 2,      //认证
    DoraemonAuthTypeVerifyToken = 3,  //本机号码校验
    DoraemonAuthTypeLoginToken = 4,    //一键登录
    DoraemonAuthTypeDeregister = 5,  //注销
    DoraemonAuthTypeUpdateTouch = 6  //更新指位
};

@interface IDaaSDoraemonManager : NSObject

/** 获取token */
@property (nonatomic,copy) NSDictionary *(^fetchAccessTokenCallBack)(NSString *mobileExtendParamsJson, NSString *mobileExtendParamsJsonSign);
/**
 *  获取该类的单例实例对象
 *  @return  单例实例对象
 */
+ (instancetype)sharedInstance;
/**
 *  获取当前SDK版本号
 *  @return  NSString，sdk版本号
 */
- (NSString *)getVersion;
/**
 *  初始化SDK调用参数，app生命周期内调用一次
 *  @param  base64EncodeKey app对应的秘钥
 *  @param  complete 结果回调到主线程
 */
- (void)setDoraemonSDKInfo:(NSString *)base64EncodeKey complete:(void (^)(NSDictionary *resultDic))complete DEPRECATED_MSG_ATTRIBUTE ("Deprecated in version 1.2.0, Please use [IDaaSDoraemonManager SDKInitWithExternalId:]");
/**
 *  获取最终请求invoke认证接口参数
 *  @param accessToken  调用不同的服务获取到不同认证的信息 (号码认证、IFAA),例如号码认证是accees_token, IFAA是Json字符串
 *  @param phoneNumber 手机号码 (只有本机号码校验才需要必传)
 *  @param complete 结果回调到主线程
 */
-(void)getMobileExtendParamsJson:(NSString *)accessToken phoneNumber:(NSString *)phoneNumber serviceCode:(NSString *)serviceCode complete:(void (^)(NSDictionary *resultDic))complete DEPRECATED_MSG_ATTRIBUTE ("Deprecated in version 1.2.0");
/**
 *  安全认证服务初始化
 *  @param applicationExternalId  应用外部ID
 *  @param appKey 应用密钥
 *  @param complete 结果回调到主线程
 */
-(void)SDKInitWithApplicationExternalId:(NSString *)applicationExternalId appKey:(NSString *)appKey complete:(void (^)(NSDictionary *resultDic))complete;
/**
 *  号码认证：支持一键登录、本机号码校验
 *  @param userId  用户ID (必填)
 *  @param action  DoraemonAuthTypeVerifyToken、DoraemonAuthTypeLoginToken
 *  @param options  UI界面展示的配置或其他额外配置
 */
-(void)SDKAuthenticateWithUserId:(NSString *)userId action:(DoraemonAuthType)action options:(UIControlOptions *)options complete:(void (^)(NSDictionary *resultDic))complete;
#pragma mark ---------IFAA认证器模式------
/**
 *  IFAA认证器-注册-认证
 *  @param method  服务类型：IFAA
 *  @param action  注册 (DoraemonAuthTypeRegister)、认证 (DoraemonAuthTypeAuth)、更新指位(DoraemonAuthTypeUpdateTouch)、注销(DoraemonAuthTypeDeregister)
 *  @param userId  用户ID
 */
- (void)authenticatorServiceWithAuthMethod:(NSString *)method action:(DoraemonAuthType)action userId:(NSString *)userId complete:(void (^)(NSDictionary *resultDic))complete;

/**
 *  IFAA认证器-注册-认证
 *  @param method  服务类型：IFAA
 *  @param action  注册 (DoraemonAuthTypeRegister)、认证 (DoraemonAuthTypeAuth)、更新指位(DoraemonAuthTypeUpdateTouch)、注销(DoraemonAuthTypeDeregister)
 *  @param userId  用户ID
 *  @param ifaaString
 */
- (void)authenticatorServiceWithAuthMethod:(NSString *)method action:(DoraemonAuthType)action userId:(NSString *)userId ifaaString:(NSString *)ifaaString complete:(void (^)(NSDictionary *resultDic))complete;

@end

