/**
 * @(#) IFAAAuthenticator module  1.0 2016/12/12
 *
 * Copyright (c) 2014, IFAA and/or its affiliates. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * -Redistribution of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *
 * -Redistribution in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *
 * Neither the name of IFAA or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
 * ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. IFAA, INC.
 * AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE
 * AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL IFAA OR ITS LICENSORS BE LIABLE FOR ANY LOST
 * REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL,
 * INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY
 * OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF IFAA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or intended
 * for use in the design, construction, operation or maintenance of any
 * nuclear facility.
 *
 * ***********************************************************************************
 *
 * This file implements the interfaces that library presents to client programs, and
 * is intended for call from Trusted Execution Application.
 */

#import <Foundation/Foundation.h>

typedef enum {
    BIO_TYPE_NONE = 0,
    IFAA_BIO_FINGERPIRNT = 1,
    BIO_TYPE_FACEID = 1 << 2,
    /// PIN码
    AUTHTYPE_PIN = 1 << 31,
    /// 手势
    AUTHTYPE_GESTURE = 1 << 30
} IFAABioType;

typedef enum {
    KEY_EXT_FALLBACK_TITLE = 1,
    KEY_EXT_CANCEL_TITLE,
    KEY_EXT_REASON_TITLE,
    ///...
} IFAAExtInfo;

@interface IFAAAuthRequest : NSObject
@property IFAABioType                       bioType;
@property (nonatomic, strong) NSString*     ifafData;

//APP调用者的应用名，
//形式为: XXX-YYY
//例: ALIPAY-Wallet, ALIBABA-Taobao
@property (nonatomic, strong) NSString*     appname;

// 其他扩展信息,如:
//@{
//    KEY_EXT_FALLBACK_TITLE : @"FALLBACK TITLE",
//    KEY_EXT_CANCEL_TITLE   : @"CANCEL TITLE",
//    KEY_EXT_REASON_TITLE   : @"REASON TITLE"
//}
@property (nonatomic, strong) NSDictionary* extInfo;
@end
