/**
 * @(#) IFAAAuthenticator module  1.0 2016/12/12
 *
 * Copyright (c) 2014, IFAA and/or its affiliates. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * -Redistribution of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *
 * -Redistribution in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *
 * Neither the name of IFAA or the names of contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
 * ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. IFAA, INC.
 * AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE
 * AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL IFAA OR ITS LICENSORS BE LIABLE FOR ANY LOST
 * REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL,
 * INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY
 * OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF IFAA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or intended
 * for use in the design, construction, operation or maintenance of any
 * nuclear facility.
 *
 * ***********************************************************************************
 *
 * This file implements the interfaces that library presents to client programs, and
 * is intended for call from Trusted Execution Application.
 */

#import <Foundation/Foundation.h>
#import "IFAAAuthRequest.h"

typedef enum {
    RESULT_SUCCESS = 100,       //成功
    RESULT_USER_CANCEL,         //用户点击了'cancel'
    RESULT_NOT_SUPPORT,         //系统版本低于iOS8
    RESULT_SYSTEM_CANCEL,       //被其他进程抢占，如来电
    RESULT_PASSCODE_NOTSET,     //passcode未设置
    RESULT_NO_MATCH,            //指纹不匹配
    RESULT_FALLBACK,            //用户点击了'Enter Passcode'
    RESULT_NOT_ENROLLED,        //未录入指纹
    RESULT_NOT_AVAILABLE,       //不可用
    RESULT_TOUCHID_ERRO,        //系统指纹异常
    RESULT_JAILBREAK,           //该机器越狱
    RESULT_WRONG_PARAM,         //参数不对
    RESULT_UNKNOWN,             //其他异常

} IFAABioResult;


@interface IFAAAuthResponse : NSObject
@property IFAABioType                       bioType;                  //生物认证类型
@property IFAABioResult                     result;                   //认证结果
@property (nonatomic, strong) NSString*     desc;                     //报错时的描述信息
@property (nonatomic, strong) NSString*     ifafData;
@property (nonatomic, strong) NSDictionary* extInfo;

+ (IFAAAuthResponse*)responseWith:(IFAABioType)bioType
                           result:(IFAABioResult)result
                         ifafData:(NSString*)ifafData
                          extInfo:(NSDictionary*)extInfo;
@end
