//
//  EtasDeregister.h
//  etasSdk
//
//  Created by ReidLee on 2018/6/15.
//  Copyright © 2018年 esandinfo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EtasResult.h"
#import "EtasConfiguration.h"
#import "IfaaCommon.h"

/**
 * 注销类, 具体如何是应用，额参考 [IFAA 注销](http://bbs.esandinfo.com/topic/44/ifaa流程拆分-ios-ifaa-注册)
 */
@interface EtasDeregister : NSObject

/**
 * 初始化函数
 * - param
    - config 执行上下文 `EtasConfiguration`
  - return self of ·EtasDeregister·
 */
- (id)initWithEtasConfiguration:(EtasConfiguration *) config;

/**
 * 注销初始化
 * - return `EtasResult`
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_STATUS_PASSCODE_NOT_SET</td>
             <td>错误描述</td>
             <td>锁屏密码没设置</td>
         </tr>
         <tr>
             <td>STATUS_NOT_ENROLLED</td>
             <td>错误描述</td>
             <td>设备尚未录入任何指纹</td>
         </tr>
         <tr>
             <td>IFAA_STATUS_NOT_REGISTERED</td>
             <td>错误描述</td>
             <td>ifaa 尚未注册</td>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>认证请求的报文</td>
             <td>需要把报文同步给服务器</td>
         </tr>
     </table>
 *
 */
- (EtasResult *) deregInit;


/**
 * 执行本地注销操作
 * - param
    - msg 服务器返回的注销报文
    - etasCallback 执行结果回调（异步执行） `EtasCallback`
 
   - return
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_SERVER_ERROR</td>
             <td>错误描述</td>
             <td>返回的报文数据异常</td>
         </tr>
         <tr>
             <td>IFAA_POLICY_REJECTED</td>
             <td>错误描述 </td>
             <td>IFAA 已被策略管理禁用</td>
         </tr>
         <tr>
             <td>IFAA_USER_REJECTED</td>
             <td>错误描述</td>
             <td>用户已被禁用</td>
         </tr>
         <tr>
             <td>IFAA_APPID_NOT_FOUND</td>
             <td>错误描述</td>
             <td>应用白名单中未设置应用标识</td>
         </tr>
         <tr>
             <td>IFAA_DEVICE_MODEL_NOT_FOUND</td>
             <td>错误描述</td>
             <td>设备型号不存在</td>
         </tr>
         <tr>
             <td>IFAA_SIGNATURE_FAIL</td>
             <td>错误描述</td>
             <td>未获取到签名数据</td>
         </tr>
         <tr>
             <td>IFAA_STATUS_NOT_REGISTERED</td>
             <td>错误描述 </td>
             <td>服务器端尚未注册</td>
         </tr>
         <tr>
             <td>IFAA_CLIENT_ERROR</td>
             <td>错误描述</td>
             <td>注销过程发生异常</td>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>注销的token </td>
             <td>注销成功</td>
         </tr>
     </table>
 */
- (void) dereg:(NSString *)msg etasCallback:(EtasCallback) etasCallback;

@end
