//
//  EtasManager.h
//  etasSdk
//
//  Created by ReidLee on 2018/2/7.
//  Copyright © 2018年 esandinfo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EtasConfiguration.h"
#import "EtasResult.h"

/*
 Etas管理类
 */
@interface EtasManager:NSObject


/**
 ***检查本机是否支持ifaa, 支持那种ifaa认证***

 - returns: ‘IFAAErrorCodeEnum’ 有可能返回如下状态码
     <table border="1">
         <tr>
             <th>可能的状态码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_STATUS_SUPPORT_OTHERS</td>
             <td>支持除指纹/人脸以外的认证类型，如pin/手势等</td>
             <td></td>
         </tr>
         <tr>
             <td>IFAA_STATUS_FINGERPRINT</td>
             <td>本机支持ifaa, 认证类型是指纹</td>
             <td></td>
         </tr>
         <tr>
             <td>IFAA_STATUS_FACE_ID</td>
             <td>本机支持ifaa, 认证类型是本地人脸</td>
             <td></td>
         </tr>
     </table>
 */
+ (enum IFAAErrorCodeEnum)isSupportIFAA;

/**
 ***获取支持的生物验证类型列表***
 
 - returns: ‘IFAAErrorCodeEnum’ 有可能返回如下状态码
 <table border="1">
 <tr>
 <th>可能的状态码</th>
 <th>内容</th>
 <th>备注</th>
 </tr>
 <tr>
 <td>IFAA_STATUS_FINGERPRINT</td>
 <td>本机支持ifaa, 认证类型是指纹</td>
 <td></td>
 </tr>
 <tr>
 <td>IFAA_STATUS_FACE_ID</td>
 <td>本机支持ifaa, 认证类型是本地人脸</td>
 <td></td>
 </tr>
 <tr>
 <td>IFAA_AUTHTYPE_PIN</td>
 <td>本机支持ifaa, 认证类型是PIN</td>
 <td></td>
 </tr>
 <tr>
 <td>IFAA_AUTHTYPE_GESTURE</td>
 <td>本机支持ifaa, 认证类型是手势</td>
 <td></td>
 </tr> 
 </table>
 */
+ (NSMutableArray*) getSupportBioTypes;


/**
 ***检查App是否有面容ID的权限***
 - returns: ‘bool’
 <table border="1">
     <tr>
         <th>可能的返回值</th>
         <th>内容</th>
         <th>备注</th>
     </tr>
     <tr>
         <td>YES</td>
         <td>App拥有面容ID的使用权限或者用户还没有决定面容ID的允许拒绝</td>
         <td></td>
     </tr>
     <tr>
         <td>NO</td>
         <td>用户拒绝App使用面容ID的权限</td>
         <td></td>
     </tr>
 </table>
 */
+ (bool)hasPermissionForFaceID;


/**
 * SimpleIFAA认证初始化
 * @param reasonTitle 指纹弹出框的reasonTitle
 * @param fallbackTitle 指纹弹出框的 fallbackTitle
 * @return EtasResult
 **/
- (EtasResult *)sAuthInit:(NSString*)reasonTitle fallbackTitle:(NSString*)fallbackTitle;


/**
 * SimpleIFAA认证
 * @param ifaaMsg SimpleIFAA认证初始化请求到IFAA服务端返回的响应报文
 * @param etasCallback 结果回调函数 `typedef void (^EtasCallback)(EtasResult* etasResult);`
 **/
- (void)sAuth:(NSString *)ifaaMsg etasCallback:(EtasCallback)etasCallback;


/**
 * SimpleIFAA认证完成方法
 * @param ifaaMsg SimpleIFAA认证请求到IFAA服务端返回的响应报文
 * @return EtasResult
 **/
- (EtasResult *)sAuthFinish:(NSString *)ifaaMsg;


/**
 ***获取SDK的版本号***

 - returns: SDK 的版本号
 */
+ (NSString *)getVersion;


//储存数据
+ (void)saveData:(NSString *)key data:(NSString *)data;

//获取保存的数据
+ (NSString *)getData:(NSString *)key;
@end
