//
//  EtasStatus.h
//  etasSdk
//
//  Created by ReidLee on 2018/6/15.
//  Copyright © 2018年 esandinfo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EtasResult.h"
#import "EtasConfiguration.h"

/**
 查询注册状态类, 此类的使用，可参考 [IFAA 查询注册状态](http://bbs.esandinfo.com/topic/43/ifaa流程拆分-ios-查询ifaa注册状态)
 */
@interface EtasStatus : NSObject

/**
 ***初始化***
 - Params:
  - config: 执行上下文 `EtasConfiguration`
 
 - returns: self of `EtasStatus`
 */
- (id)initWithEtasConfiguration:(EtasConfiguration *) config;

/**
 * 查询ifaa注册状态
 * - return `EtasResult`
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_STATUS_REGISTERED</td>
             <td>注册的 token</td>
             <td>说明已经注册</td>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>向etas服务器查询注册状态的报文</td>
             <td>需要把报文同步到服务器，查询服务器是否已经注册</td>
         </tr>
     </table>
 */
- (EtasResult *) checkStatusInit;

/**
 * 解析服务器返回的报文
 * - param
     -msg 服务器返回的报文数据
  - return `EtasResult`
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_SERVER_ERROR</td>
             <td>具体的错误描述</td>
             <td>返回的报文解析出错（可能是网络错误，可能是服务器异常）</td>
         </tr>
         <tr>
             <td>IFAA_POLICY_REJECTED</td>
             <td>错误描述 </td>
             <td>IFAA 已被策略管理禁用</td>
         </tr>
         <tr>
             <td>IFAA_USER_REJECTED</td>
             <td>错误描述</td>
             <td>用户已被禁用</td>
         </tr>
         <tr>
             <td>IFAA_APPID_NOT_FOUND</td>
             <td>错误描述</td>
             <td>应用白名单中未设置应用标识</td>
         </tr>
         <tr>
             <td>IFAA_DEVICE_MODEL_NOT_FOUND</td>
             <td>错误描述</td>
             <td>设备型号不存在</td>
         </tr>
         <tr>
             <td>IFAA_SIGNATURE_FAIL</td>
             <td>错误描述</td>
             <td>未获取到签名数据</td>
         </tr>
         <tr>
             <td>IFAA_STATUS_NOT_REGISTERED</td>
             <td>异常信息</td>
             <td>说明此设备在服务器端尚未注册</td>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>注册的token</td>
             <td>说明服务器端已经注册</td>
         </tr>
     </table>
 */
- (EtasResult *) parseResult:(NSString *)msg;

/**
 * 检查本地 IFAA 注册状态
 * - param
    - token 注册的token
 * - return `EtasResult`
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
 
         <tr>
             <td>IFAA_STATUS_PASSCODE_NOT_SET</td>
             <td>错误描述</td>
             <td>锁屏密码没设置</td>
         </tr>

         <tr>
             <td>IFAA_STATUS_NOT_ENROLLED</td>
             <td>错误描述</td>
             <td>本地没有录入任何指纹/人脸</td>
         </tr>
 
         <tr>
             <td>STATUS_NOT_REGISTERED</td>
             <td>错误描述</td>
             <td>说明手机尚未注册</td>
         </tr>
         <tr>
             <td>IFAA_CLIENT_ERROR</td>
             <td>异常描述</td>
             <td>查询本地注册状态时发生异常</td>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>注册的token</td>
             <td>说明客户端已经注册</td>
         </tr>
     </table>
 */
- (EtasResult *) checkLocalStatus:(NSString *)token;

@end
