//
//  EtasTemplateUpdater.h
//  etasSdk
//
//  Created by ReidLee on 2018/6/15.
//  Copyright © 2018年 esandinfo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EtasResult.h"
#import "EtasConfiguration.h"
#import "IfaaCommon.h"

/**
 * 指位更新类, 此类的使用，可参考 [指纹更新](http://bbs.esandinfo.com/topic/46/ifaa流程拆分-ios-ifaa-指位更新)
 */
@interface EtasTemplateUpdater : NSObject

/**
 * 初始化函数
 * - param
    - config IFAA 执行上下文 `EtasConfiguration`
 */
- (id)initWithEtasConfiguration:(EtasConfiguration *) config;

/**
 * 指位更新初始化
 * - param
    - ifaaMessage 指位更新报文，从认证类中返回
 * - return `EtasResult`
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>认证请求的报文</td>
             <td>需要把报文同步给服务器</td>
         </tr>
     </table>
 */
- (EtasResult *) templateUpdaInit:(NSString *)ifaaMessage;

/**
 * 告知SDK 指位更新操作已完成
 * - param ifaaMsg 指位更新报文
    - return `EtasResult`
     <table border="1">
         <tr>
             <th>可能的错误码</th>
             <th>内容</th>
             <th>备注</th>
         </tr>
         <tr>
             <td>IFAA_SERVER_ERROR</td>
             <td>错误描述</td>
             <td>返回的报文数据异常</td>
         </tr>
         <tr>
             <td>IFAA_POLICY_REJECTED</td>
             <td>错误描述 </td>
             <td>IFAA 已被策略管理禁用</td>
         </tr>
         <tr>
             <td>IFAA_USER_REJECTED</td>
             <td>错误描述</td>
             <td>用户已被禁用</td>
         </tr>
         <tr>
             <td>IFAA_SUCCESS</td>
             <td>注册的token数据</td>
             <td>说明指位更新操作成功</td>
         </tr>
     </table>
 */
- (EtasResult *) templateUpdaFinish:(NSString *)msg;

@end
